//
//  Copyright 2010 Justin.tv. All rights reserved.
//

#import "UIDeviceAdditions.h"

#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <ifaddrs.h>

@implementation UIDevice (Additions)
- (BOOL) isPad {
	static BOOL checked = NO;
	static BOOL result = NO;
	if (checked)
		return result;

	checked = YES;
	result = ([UIDevice currentDevice].userInterfaceIdiom == UIUserInterfaceIdiomPad);

	return result;
}

- (BOOL) isPhone {
	static BOOL checked = NO;
	static BOOL result = NO;
	if (checked)
		return result;

	checked = YES;
	result = ([UIDevice currentDevice].userInterfaceIdiom == UIUserInterfaceIdiomPhone);

	return result;
}

- (BOOL) isTallPhone {
	static BOOL checked = NO;
	static BOOL result = NO;
	if (checked)
		return result;

	checked = YES;
	result = ([UIDevice currentDevice].userInterfaceIdiom == UIUserInterfaceIdiomPhone) && ([UIScreen mainScreen].bounds.size.height > 480.);

	return result;
}

- (BOOL) isRunningOS6 {
	return [UIDevice currentDevice].systemVersion.floatValue >= 6.;
}

- (BOOL) isRunningOS7 {
	return [UIDevice currentDevice].systemVersion.floatValue >= 7.;
}

- (BOOL) isRunningOS8 {
	return [UIDevice currentDevice].systemVersion.floatValue >= 8.;
}

#pragma mark -

- (NSString *) _addressOfInterfaceNamed:(const char *) name {
	struct ifaddrs *interfaces = NULL;

	// this is a C API, so, non-zero returns means there is an error
	if (getifaddrs(&interfaces))
		return @"127.0.0.1";

	struct ifaddrs *iterator = interfaces;
	while (iterator) {
		if (iterator->ifa_addr->sa_family == AF_INET) {
			if (!strcmp(iterator->ifa_name, name)) {
				NSString *address = [[NSString stringWithUTF8String:inet_ntoa(((struct sockaddr_in *)iterator->ifa_addr)->sin_addr)] copy];

				freeifaddrs(interfaces);

				return address;
			}
		}

		iterator = iterator->ifa_next;
	}

	freeifaddrs(interfaces);

	return nil;
}

- (NSString *) localIP {
	NSString *address = [self _addressOfInterfaceNamed:"en0"];
	if (!address.length)
		address = [self _addressOfInterfaceNamed:"en1"];
	if (!address.length)
		address =  @"127.0.0.1";

	return address;
}
@end
